clear all
clc

% === Percorso della cartella contenente i file .log ===
dataFolder = 'C:\Users\Franc\Desktop\FBG\14 novembre3';
savePath = 'C:\Users\Franc\Desktop\MatlabProve\14 Novembre';

% Crea la cartella di salvataggio se non esiste
if ~exist(savePath, 'dir')
    mkdir(savePath);
end

% === Elenca tutti i file .log ===
files = dir(fullfile(dataFolder, '*.log'));

if isempty(files)
    error('Nessun file .log trovato in %s', dataFolder);
end

fprintf('Trovati %d file .log nella cartella.\n', numel(files));

for f = 1:numel(files)
    filename = fullfile(files(f).folder, files(f).name);
    fprintf('\n--- Elaborazione file %d/%d: %s ---\n', f, numel(files), files(f).name);

    % === Apertura file ===
    fid = fopen(filename, 'r');
    if fid == -1
        warning('Impossibile aprire il file: %s', filename);
        continue;
    end

    % === Lettura di tutte le righe ===
    raw = textscan(fid, '%s', 'Delimiter', '\n');
    fclose(fid);
    lines = raw{1};

    % === Trova la riga da cui iniziano i dati numerici ===
    dataStart = find(contains(lower(lines), 'time'), 1, 'last') + 2;

    if isempty(dataStart)
        warning('Intestazione "Time" non trovata in %s', files(f).name);
        continue;
    end

    % === Estrai solo i dati numerici ===
    dataLines = lines(dataStart:end);
    n = numel(dataLines);
    data = nan(n, 4);

    for i = 1:n
        line = strrep(dataLines{i}, ',', '.');
        tokens = regexp(strtrim(line), '\s+', 'split');
        if numel(tokens) >= 4
            nums = str2double(tokens(1:4));
            if ~any(isnan(nums))
                data(i,:) = nums;
            end
        end
    end

    % === Rimuovi righe vuote ===
    data = data(all(~isnan(data),2), :);

    if isempty(data)
        warning('Nessun dato valido trovato in %s', files(f).name);
        continue;
    end

    % === Estrai colonne ===
    time = data(:,1);
    sensor1 = data(:,2);
    sensor2 = data(:,3);
    sensor3 = data(:,4);

    % === Crea timestamp univoco dal nome file ===
    [~, baseName, ~] = fileparts(files(f).name);
    timestamp = datestr(now, 'yyyy-mm-dd_HH-MM-SS');
    matFile = fullfile(savePath, sprintf('%s_%s.mat', baseName, timestamp));
    csvFile = fullfile(savePath, sprintf('%s_%s.csv', baseName, timestamp));

    % === Salva i risultati ===
    save(matFile, 'time', 'sensor1', 'sensor2', 'sensor3');
    T = table(time, sensor1, sensor2, sensor3);
    writetable(T, csvFile);

    fprintf('  → Importati %d campioni. File salvati:\n', size(data,1));
    fprintf('    %s\n    %s\n', matFile, csvFile);
end

fprintf('\nElaborazione completata per tutti i file.\n');
